# coding: utf-8
from botocore.exceptions import ClientError

ec2 = session.get_client('ec2', 'us-east-2')
try:
    parsed = ec2.describe_instances(InstanceIds=['i-badid'])
except ClientError as e:
    logger.error("Błąd: %s", e, exc_info=True)
    # Obsługa tylko określonego przypadku błędu.
    if e.response['Error']['Code'] == 'InvalidInstanceID.NotFound':
        raise WrongInstanceIDError(message=exc_info, errors=e)

class WrongInstanceIDError(Exception):
    """Zgłoszenie wyjątku w przypadku błędnej instancji."""
    def __init__(self, message=None, errors=None):
        # Wywołanie konstruktora klasy bazowej z wymaganymi argumentami.
        super().__init__(message)
        self.errors = errors