﻿using PostSharp.Aspects;
using PostSharp.Serialization;
using System;

namespace CrossCuttingConcerns.Logging
{
    [PSerializable]
    public class ConsoleLoggingAspect : OnMethodBoundaryAspect
    {
        public override void OnEntry(MethodExecutionArgs args)
        {
            Console.WriteLine($"Metoda: {args.Method.Name}, OnEntry().");
        }

        public override void OnExit(MethodExecutionArgs args)
        {
            Console.WriteLine($"Metoda: {args.Method.Name}, OnExit().");
        }

        public override void OnSuccess(MethodExecutionArgs args)
        {
            Console.WriteLine($"Metoda: {args.Method.Name}, OnSuccess().");
        }

        public override void OnException(MethodExecutionArgs args)
        {
            Console.WriteLine($"Wyjątek zgłoszony w {args.Method.Name}. {args}");
        }
    }
}