# Clean Code in C# 

<a href="https://www.packtpub.com/programming/clean-code-in-c?utm_source=github&utm_medium=repository&utm_campaign=9781838982973"><img src="https://www.packtpub.com/media/catalog/product/cache/bf3310292d6e1b4ca15aeea773aca35e/9/7/9781838982973-original_27.jpeg" alt="Clean Code in C# " height="256px" align="right"></a>

This is the code repository for [Clean Code in C# ](https://www.packtpub.com/programming/clean-code-in-c?utm_source=github&utm_medium=repository&utm_campaign=9781838982973), published by Packt.

**Refactor your legacy C# code base and improve application performance by applying best practices**

## What is this book about?
Traditionally associated with developing Windows desktop applications and games, C# is now used in a wide variety of domains, such as web and cloud apps, and has become increasingly popular for mobile development. Despite its extensive coding features, professionals experience problems related to efficiency, scalability, and maintainability because of bad code. Clean Code in C# will help you identify these problems and solve them using coding best practices.


This book covers the following exciting features:
* Write code that allows software to be modified and adapted over time 
* Implement the fail-pass-refactor methodology using a sample C# console application 
* Address cross-cutting concerns with the help of software design patterns 
* Write custom C# exceptions that provide meaningful information 
* Identify poor quality C# code that needs to be refactored 
* Secure APIs with API keys and protect data using Azure Key Vault 
* Improve your code’s performance by using tools for profiling and refactoring

If you feel this book is for you, get your [copy](https://www.amazon.com/dp/1838982973) today!

<a href="https://www.packtpub.com/?utm_source=github&utm_medium=banner&utm_campaign=GitHubBanner"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" 
alt="https://www.packtpub.com/" border="5" /></a>

## Instructions and Navigations
All of the code is organized into folders. For example, Chapter02.

The code will look like the following:
```
using CH10_DividendCalendar.Security.Authentication;
using System.Threading.Tasks;
namespace CH10_DividendCalendar.Repository
{
public interface IRepository
{
Task<ApiKey> GetApiKey(string providedApiKey);
}
}
```

**Following is what you need for this book:**
This book is aimed at computer programmers with a good grasp of the C# programming language who would like guidance on identifying problematic code and writing clean code in C#. Primarily, the reader base will range from graduate to mid-level programmers, but even senior programmers may find this book valuable.

With the following software and hardware list you can run all code files present in the book (Chapter 1-14).
### Software and Hardware List
| Chapter | Software required | OS required |
| -------- | ------------------------------------ | ----------------------------------- |
| 1-14 | Visual Studio 2019 | Windows, Mac OS X, and Linux (Any) |
| 1-14 | Atom | Windows, Mac OS X, and Linux (Any) |
| 1-14 | Postman | Windows, Mac OS X, and Linux (Any) |

We also provide a PDF file that has color images of the screenshots/diagrams used in this book. [Click here to download it]( https:/?/?static.?packt-?cdn.?com/?downloads/).

### Related products
* Hands-On Software Architecture with C# 8 and .NET Core 3  [[Packt]](https://www.packtpub.com/programming/hands-on-software-architecture-with-c-8?utm_source=github&utm_medium=repository&utm_campaign=9781789800937) [[Amazon]](https://www.amazon.com/dp/1789800935)

* Learn C# Programming [[Packt]](https://www.packtpub.com/programming/learn-c-8?utm_source=github&utm_medium=repository&utm_campaign=) [[Amazon]](https://www.amazon.com/dp/1789805864)

## Get to Know the Author
**Jason Alls**
has been programming for over 21 years using Microsoft technologies. Working
with an Australasian company, he started his career developing call center management reporting software used by global clients including telecom providers, banks, airlines, and the police. He then moved on to develop GIS marketing applications and worked in the banking sector performing data migrations between Oracle and SQL Server. Certified as an MCAD in C# since 2005, he has been involved in the development of various desktop, web,
and mobile applications.
Currently employed by a globally recognized leader in the educational software sector, he develops and supports dyslexia testing and assessment software written in ASP.NET, Angular, and C#.

### Suggestions and Feedback
[Click here](https://docs.google.com/forms/d/e/1FAIpQLSdy7dATC6QmEL81FIUuymZ0Wy9vH1jHkvpY57OiMeKGqib_Ow/viewform) if you have any feedback or suggestions.


