﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Diagnostics;

namespace CH05_MSTestUnitTesting.Tests
{
    // Klasa zawierająca testy jednostkowe MSTest. (Wymagane)
    [TestClass]
    public class UnitTest1
    {
        private static void WriteSeparatorLine()
        {
            Debug.WriteLine("--------------------------------------------------");
        }

        [AssemblyInitialize]
        public static void AssemblyInit(TestContext context)
        {
            WriteSeparatorLine();
            Debug.WriteLine("Opcjonalnie: AssemblyInitialize");
            Debug.WriteLine("Uruchamia się raz przed uruchomieniem testów.");
        }

        [ClassInitialize]
        public static void TestFixtureSetup(TestContext context)
        {
            WriteSeparatorLine();
            Debug.WriteLine("Opcjonalnie: ClassInitialize");
            Debug.WriteLine("Uruchamia się raz dla klasy testu.");
        }

        [TestInitialize]
        public void Setup()
        {
            WriteSeparatorLine();
            Debug.WriteLine("Opcjonalnie: TestInitialize");
            Debug.WriteLine("Uruchamia się raz przed każdym testem.");
        }

        [TestMethod]
        public void TestMethod1()
        {
            WriteSeparatorLine();
            Debug.WriteLine("Obowiązkowy: TestMethod");
            Debug.WriteLine("Metoda testu, która będzie uruchomiona przez odtwarzacz testów.");
            Debug.WriteLine("Ta metoda wyświetli się na liście testów.");
            Assert.IsTrue(true);
            Assert.Fail();
        }

        [AssemblyCleanup]
        public static void AssemblyCleanup()
        {
            WriteSeparatorLine();
            Debug.WriteLine("Opcjonalnie: AssemblyCleanup");
            Debug.WriteLine("Uruchamia się raz po wykonaniu testów.");
        }

        [ClassCleanup]
        public static void TestFixtureTearDown()
        {
            WriteSeparatorLine();
            Debug.WriteLine("Opcjonalnie: ClassCleanup");
            Debug.WriteLine("Uruchamia się raz po wykonaniu wszystkich testów w klasie testowej.");
            Debug.WriteLine("Nie ma gwarancji, że metoda uruchomi się natychmiast po wykonaniu wszystkich testów w klasie.");
        }

        [TestCleanup]
        public void Teardown()
        {
            WriteSeparatorLine();
            Debug.WriteLine("Opcjonalnie: TestCleanup");
            Debug.WriteLine("Uruchamia się po każdym teście.");
        }
    }
}
