﻿using CH11_AddressingCrossCuttingConcerns.Attributes;
using PostSharp.Aspects;
using PostSharp.Extensibility;
using PostSharp.Serialization;
using System.Reflection;

namespace CH11_AddressingCrossCuttingConcerns.Aspects
{
    [PSerializable]
    [LinesOfCodeAvoided(2)]
    public sealed class FilterMethodArgumentsAspect : MethodInterceptionAspect
    {
        private FilterAttribute[] _filters;

        internal FilterMethodArgumentsAspect(MethodBase method)
        {
            _filters = new FilterAttribute[method.GetParameters().Length];
        }


        internal void SetFilter(ParameterInfo parameter, FilterAttribute filter)
        {
            if (_filters[parameter.Position] != null)
            {
                // Jeśli chcesz obsługiwać więcej niż 1 filtr, będziesz potrzebować bardziej złożonych struktur danych i obsługiwać priorytety.
                Message.Write(parameter, SeverityType.Error, "MY01", "Nie może być więcej niż 1 filtra w parametrze {0}.",
                  parameter);
                return;
            }

            _filters[parameter.Position] = filter;
        }

        public override void OnInvoke(MethodInterceptionArgs args)
        {
            for (var i = 0; i < _filters.Length; i++)
            {
                var filter = _filters[i];
                if (filter != null)
                {
                    args.Arguments[i] = filter.ApplyFilter(args.Arguments[i]);
                }
            }

            args.Proceed();
        }
    }
}
