﻿namespace CH3.LawOfDemeter
{
    /// <summary>
    /// Dobry i zły przykład  
    /// prawa Demeter.
    /// </summary>
    public class Example
    {
        /// <summary>
        /// Łamie prawo Demeter, ponieważ 
        /// gettery zwracają różne
        /// obiekty.
        /// </summary>
        public void BadExample_Chaining()
        {
            var report = new Report();
            report.Database.Connection.Open();
        }

        /// <summary>
        /// Ten przykład jest zgodny z  
        /// prawem Demeter, ponieważ wywołuje tylko
        /// bezpośrednią metodę obiektu zapisanego
        /// w zmiennej.
        /// </summary>
        public void GoodExample()
        {
            var report = new Report();
            report.OpenConnection();
        }
    }
}

