﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CH05_AvoidNullPointerExceptions
{
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                Person person = null;
                var program = new Program();
                //program.TryCatchExample(person);
                program.ArgumentNullValidatorExample(person);
            }
            catch (Exception ex)
            {
                Console.WriteLine($"Błąd: {ex.Message}");
            }
            finally
            {
                Console.ReadKey();
            }
        }

        private void TryCatchExample(Person person)
        {
            try
            {
                Console.WriteLine($"Nazwisko osoby: {person.Name}");
            }
            catch (NullReferenceException nre)
            {
                Console.WriteLine("Błąd: Argument person nie może mieć wartości null.");
                throw;
            }
        }

        private void ArgumentNullValidatorExample(Person person)
        {
            ArgumentNullValidator.NotNull("Person", person);
            Console.WriteLine($"Nazwisko osoby: {person.Name}");
        }
    }
}
