"""Abstrakcje dla statusu dostawy."""
from typing import Union


class DispatchedOrder:
"""Zamówienie, które zostało właśnie utworzone i zostało wysłane powiadomienie
   o rozpoczęciu dostawy
"""

    status = "dispatched"

    def __init__(self, when):
        self._when = when

    def message(self) -> dict:
        return {
            "status": self.status,
            "msg": "Zamówienie zostało wysłane w dniu {0}".format(
                self._when.isoformat()
            ),
        }


class OrderInTransit:
    """Zamówienie, które jest aktualnie wysyłane do klienta."""

    status = "in transit"

    def __init__(self, current_location):
        self._current_location = current_location

    def message(self) -> dict:
        return {
            "status": self.status,
            "msg": "Dostawa w trakcie realizacji (bieżąca lokalizacja: {})".format(
                self._current_location
            ),
        }


class OrderDelivered:
    """Zamówienie dostarczone do klienta."""

    status = "delivered"

    def __init__(self, delivered_at):
        self._delivered_at = delivered_at

    def message(self) -> dict:
        return {
            "status": self.status,
            "msg": "Zamówienie dostarczone w dniu {0}".format(
                self._delivered_at.isoformat()
            ),
        }


class DeliveryOrder:
    def __init__(
        self,
        delivery_id: str,
        status: Union[DispatchedOrder, OrderInTransit, OrderDelivered],
    ) -> None:
        self._delivery_id = delivery_id
        self._status = status

    def message(self) -> dict:
        return {"id": self._delivery_id, **self._status.message()}
