"""Czysty kod w Pythonie - Rozdział 09: Typowe wzorce projektowe

> Wzorzec Monostat: Borg
"""
from log import logger


class SharedAllMixin:
    def __init__(self, *args, **kwargs):
        try:
            self.__class__._attributes
        except AttributeError:
            self.__class__._attributes = {}

        self.__dict__ = self.__class__._attributes
        super().__init__(*args, **kwargs)


class BaseFetcher:
    def __init__(self, source):
        self.source = source


class TagFetcher(SharedAllMixin, BaseFetcher):
    def pull(self):
        logger.info("pobieranie ze znacznika %s", self.source)
        return f"Tag = {self.source}"


class BranchFetcher(SharedAllMixin, BaseFetcher):
    def pull(self):
        logger.info("pobieranie z gałęzi %s", self.source)
        return f"Branch = {self.source}"
