"""Czysty kod w Pythonie - Rozdział 7: Generatory, iteratory i programowanie asynchroniczne

> Iterowanie idiomatyczne: upraszczanie pętli

"""
import unittest

from log import logger


def search_nested_bad(array, desired_value):
    """Przykład iteracji w pętli zagnieżdżonej."""
    coords = None
    for i, row in enumerate(array):
        for j, cell in enumerate(row):
            if cell == desired_value:
                coords = (i, j)
                break

        if coords is not None:
            break

    if coords is None:
        raise ValueError(f"{desired_value} nie znaleziono")

    logger.info("wartość %r znaleziona w punkcie [%i, %i]", desired_value, *coords)
    return coords


def _iterate_array2d(array2d):
    for i, row in enumerate(array2d):
        for j, cell in enumerate(row):
            yield (i, j), cell


def search_nested(array, desired_value):
    """"Przeszukiwanie w wielu wymiarach za pomocą pojedynczej pętli."""
    try:
        coord = next(
            coord
            for (coord, cell) in _iterate_array2d(array)
            if cell == desired_value
        )
    except StopIteration as e:
        raise ValueError(f"{desired_value} nie znaleziono") from e

    logger.info("wartość %r znaleziona w punkcie [%i, %i]", desired_value, *coord)
    return coord


if __name__ == "__main__":
    unittest.main()
