"""Czysty kod w Pythonie - Rozdział 7: Generatory, iteratory i programowanie asynchroniczne

> Interfejs iteracji: sekwencje

"""

import logging

logger = logging.getLogger(__name__)


class SequenceWrapper:
    def __init__(self, original_sequence):
        self.seq = original_sequence

    def __getitem__(self, item):
        value = self.seq[item]
        logger.debug("%s pobiera %s", self.__class__.__name__, item)
        return value

    def __len__(self):
        return len(self.seq)


class MappedRange:
    """Zastosowanie transformacji do zakresu liczb."""

    def __init__(self, transformation, start, end):
        self._transformation = transformation
        self._wrapped = range(start, end)

    def __getitem__(self, index):
        value = self._wrapped.__getitem__(index)
        result = self._transformation(value)
        logger.info("Indeks %d: %s", index, result)
        return result

    def __len__(self):
        return len(self._wrapped)
