"""Czysty kod w Pythonie - Rozdział 7: Generatory, iteratory i programowanie asynchroniczne

> Interfejs iteracji

    * Rozróżnienie pomiędzy obiektami iterowalnymi, a iteratorami
    * Tworzenie iteratorów
"""


class SequenceIterator:
    """
    >>> si = SequenceIterator(1, 2)
    >>> next(si)
    1
    >>> next(si)
    3
    >>> next(si)
    5
    """

    def __init__(self, start=0, step=1):
        self.current = start
        self.step = step

    def __next__(self):
        value = self.current
        self.current += self.step
        return value
