"""Czysty kod w Pythonie - Rozdział 3: Ogólne cechy dobrego kodu

> Dziedziczenie wielokrotne: MRO

"""


class BaseModule:
    module_name = "top"

    def __init__(self, module_name):
        self.name = module_name

    def __str__(self):
        return f"{self.module_name}:{self.name}"


class BaseModule1(BaseModule):
    module_name = "moduł-1"


class BaseModule2(BaseModule):
    module_name = "moduł-2"


class BaseModule3(BaseModule):
    module_name = "moduł-3"


class ConcreteModuleA12(BaseModule1, BaseModule2):
    """Rozszerza moduły 1 i 2

    >>> str(ConcreteModuleA12('name'))
    'moduł-1:name'
    """


class ConcreteModuleB23(BaseModule2, BaseModule3):
    """Rozszerza moduły 2 i 3

    >>> str(ConcreteModuleB23("test"))
    'moduł-2:test'
    """
