"""Czysty kod w Pythonie - Rozdział 5: Dekoratory

> Przykład pożądanych skutków ubocznych w dekoratorach

"""


EVENTS_REGISTRY = {}


def register_event(event_cls):
    """Aby klasa zdarzenia była dostępna w module, umieść ją w rejestrze
    """
    EVENTS_REGISTRY[event_cls.__name__] = event_cls
    return event_cls


class Event:
    """Klasa bazowa zdarzenia"""


class UserEvent:
    TYPE = "user"


@register_event
class UserLoginEvent(UserEvent):
    """Reprezentuje zdarzenie użytkownika, który przed chwilą uzyskał dostęp do systemu."""


@register_event
class UserLogoutEvent(UserEvent):
    """Zdarzenie wyzwalane bezpośrednio po wylogowaniu użytkownika z systemu."""


def test():
    """
    >>> sorted(EVENTS_REGISTRY.keys()) == sorted(('UserLoginEvent', 'UserLogoutEvent'))
    True
    """
