"""Czysty kod w Pythonie - Rozdział 3: Ogólne cechy dobrego kodu

> Obsługa błędów - Wyjątki
"""
import logging
import time

from base import Connector, Event

logger = logging.getLogger(__name__)


class DataTransport:
    """Przykład obiektu obsługującego wyjątki na różnych poziomach."""

    _RETRY_BACKOFF: int = 5
    _RETRY_TIMES: int = 3

    def __init__(self, connector: Connector) -> None:
        self._connector = connector
        self.connection = None

    def deliver_event(self, event: Event):
        try:
            self.connect()
            data = event.decode()
            self.send(data)
        except ConnectionError as e:
            logger.info("wykryto błąd połączenia: %s", e)
            raise
        except ValueError as e:
            logger.error("%r zawiera nieprawidłowe dane: %s", event, e)
            raise

    def connect(self):
        for _ in range(self._RETRY_TIMES):
            try:
                self.connection = self._connector.connect()
            except ConnectionError as e:
                logger.info(
                    "%s: próba nawiązania nowego połączenia za %is",
                    e,
                    self._RETRY_BACKOFF,
                )
                time.sleep(self._RETRY_BACKOFF)
            else:
                return self.connection
        raise ConnectionError(
            f"Nie można nawiązać połączenia po podjęciu {self._RETRY_TIMES} prób"
        )

    def send(self, data: bytes):
        return self.connection.send(data)
