# import pandas and pyarrow
import pandas as pd
import pyarrow
pd.options.display.float_format = '{:,.2f}'.format
pd.set_option('display.width', 68)
pd.set_option('display.max_columns', 3)

# import the land temperature data
landtemps = pd.read_csv('dane/landtempssample.csv',
    names=['ID_stacji','rok','miesiąc','średnia_temperatura','szerokość_geograficzna',
      'długość_geograficzna','wysokość','stacja','ID_państwa','nazwa_państwa'],
    skiprows=1,
    parse_dates=[['miesiąc','rok']],
    low_memory=False)

landtemps.rename(columns={'miesiąc_rok':'data_pomiaru'}, inplace=True)
landtemps.dropna(subset=['średnia_temperatura'], inplace=True)
landtemps.dtypes
landtemps.set_index(['data_pomiaru','ID_stacji'], inplace=True)

# write extreme values of temperature out to Excel and CSV files
extremevals = landtemps[(landtemps.średnia_temperatura < landtemps.średnia_temperatura.quantile(.001)) | (landtemps.średnia_temperatura > landtemps.średnia_temperatura.quantile(.999))]
extremevals.shape
extremevals.sample(7)
extremevals.to_excel('widoki/tempext.xlsx')
extremevals.to_csv('widoki/tempext.csv')

# save to pickle and feather files
landtemps.to_pickle('dane/landtemps.pkl')
landtemps.reset_index(inplace=True)
landtemps.to_feather("dane/landtemps.ftr")

# load saved pickle and feather files
landtemps = pd.read_pickle('dane/landtemps.pkl')
landtemps.head(2).T
landtemps = pd.read_feather("dane/landtemps.ftr")
landtemps.head(2).T
