import pandas as pd
pd.options.display.float_format = '{:,.2f}'.format
pd.set_option('display.width', 75)
pd.set_option('display.max_columns', 5)

# import the land temperature data
landtemps = pd.read_csv('dane/landtempssample.csv',
    names=['ID_stacji','rok','miesiąc','średnia_temperatura','szerokość_geograficzna',
      'długość_geograficzna','wysokość','stacja','ID_państwa','nazwa_państwa'],
    skiprows=1,
    parse_dates=[['miesiąc','rok']],
    low_memory=False)

type(landtemps)

# show enough data to get a sense of how the import went
landtemps.head(7)
landtemps.dtypes
landtemps.shape

# fix the column name for the date
landtemps.rename(columns={'miesiąc_rok':'data_pomiaru'}, inplace=True)
landtemps.dtypes
landtemps.średnia_temperatura.describe()
landtemps.isnull().sum()

# remove rows with missing values
landtemps.dropna(subset=['średnia_temperatura'], inplace=True)
landtemps.shape
