{
   Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}
unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, ValEdit, TlHelp32, ImgList, ComCtrls, ShellAPI;

type
  TMainForm = class(TForm)
    lvProcess: TListView;
    imgList: TImageList;
    procedure FormCreate(Sender: TObject);
    procedure lvProcessClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
     SnapShot : THandle;
  end;

var
  MainForm: TMainForm;

implementation

uses ThreadFrm;

{$R *.dfm}


procedure TMainForm.FormCreate(Sender: TObject);
var
  PE : TProcessEntry32;
  ListItem : TListItem;
  Icon : TIcon;
begin
{ zrzut systemowy }
  SnapShot := CreateToolHelp32Snapshot(TH32CS_SNAPALL, 0);
  PE.dwSize := SizeOf(PE); // okrela rozmiar rekordu

  Icon := TIcon.Create;

  if Process32First(SnapShot, PE) then
  begin
  { ptla }
    while Process32Next(SnapShot, PE) do
    begin

      ListItem := lvProcess.Items.Add;
      ListItem.Caption := IntToStr(PE.cntUsage);
      ListItem.SubItems.Add(IntToHex(PE.th32ProcessID, 8));
      ListItem.SubItems.Add(IntToStr(PE.cntThreads));
      ListItem.SubItems.Add(IntToHex(PE.th32ParentProcessID, 8));
      ListItem.SubItems.Add(PE.szExeFile);

      { "wycignicie" ikony }
      Icon.Handle := ExtractIcon(hInstance, PE.szExeFile, 0);
      imgList.AddIcon(Icon); // dodanie ikon
      ListItem.ImageIndex := imgList.Count -1; // ustawienie numeru ikony


    end;
  end;
  Icon.Free;
end;

procedure TMainForm.lvProcessClick(Sender: TObject);
begin
{ otwarcie okna }
  ThreadForm := TThreadForm.Create(Application);

  ThreadForm.ShowModal;
  ThreadForm.Free;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
// zwolnienie zasobu
  CloseHandle(SnapShot);
end;

end.
