{
  Copyright (C) 2002 by Adam Boduch <adam@4programmers.net>
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    edtWidth: TEdit;
    edtHeight: TEdit;
    btnSet: TButton;
    cbMode: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure btnSetClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  edtWidth.Text := IntToStr(Screen.DesktopWidth);
  edtHeight.Text := IntToStr(Screen.DesktopHeight);
end;

procedure TForm1.btnSetClick(Sender: TObject);
var
  Mode : TDeviceMode;
  Flag : DWORD;
  Result : Integer;
begin
  Mode.dmSize := SizeOf(Mode);  // rozmiar struktury
  { odczytaj wartci z kontrolek Edit }
  Mode.dmPelsWidth := StrToInt(edtWidth.Text);
  Mode.dmPelsHeight := StrToInt(edtHeight.Text);
  Mode.dmFields:=DM_PELSWIDTH + DM_PELSHEIGHT;

  { w zalenoci od ustawionej pozycji w Combo - ustaw odpowiedni flag }
  case cbMode.ItemIndex of
    0: Flag := 0;
    1: Flag := CDS_UPDATEREGISTRY;
    2: Flag := CDS_TEST;
    else Flag := 0;
  end;

  Result := ChangeDisplaySettings(Mode, Flag);
  { wywietl rezultat }
  case Result of
    DISP_CHANGE_SUCCESSFUL: ShowMessage('Rozdzielczo prawidowo ustawiona!');
    DISP_CHANGE_RESTART: ShowMessage('Komputer musi zosta zresetowany, aby ustawienia zostay zaakceptowane');
    DISP_CHANGE_FAILED: ShowMessage('Ustawnie nie powiodo si');
  end;

end;

end.
