{
  Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DBXpress, DB, SqlExpr, StdCtrls, FMTBcd, Grids, ValEdit,
  ComCtrls;

type
  TMainForm = class(TForm)
    MySQL: TSQLConnection;
    btnConnect: TButton;
    SQL: TSQLDataSet;
    ListView: TListView;
    btnLoad: TButton;
    procedure btnConnectClick(Sender: TObject);
    procedure MySQLAfterConnect(Sender: TObject);
    procedure MySQLAfterDisconnect(Sender: TObject);
    procedure btnLoadClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    Connected : Boolean;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.btnConnectClick(Sender: TObject);
begin
  if Connected then Connected := False else Connected := True;
  MySQL.Connected := Connected;
end;

procedure TMainForm.MySQLAfterConnect(Sender: TObject);
begin
  btnConnect.Caption := 'Rozcz';
  btnLoad.Enabled := True;
end;

procedure TMainForm.MySQLAfterDisconnect(Sender: TObject);
begin
  btnConnect.Caption := 'Pocz';
  btnLoad.Enabled := False;
end;

procedure TMainForm.btnLoadClick(Sender: TObject);
var
  i : Integer;
  ListItem : TListItem;
begin
  SQL.CommandText := 'SELECT * FROM users'; // zapytanie
  SQL.Open; // odczytaj dane

  for I := 1 to SQL.RecordCount do
  begin
  { dodaj kolejne wartoci }
    ListItem := ListView.Items.Add;
    ListItem.Caption := IntToStr(SQL.FieldValues['id']);
    ListItem.SubItems.Add(SQL.FieldValues['name']);
    ListItem.SubItems.Add(SQL.FieldValues['mail']);
    SQL.Next;
  end;

  SQL.Close;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
// podczas zamknicia programu - rozczenie z serwerem
  MySQL.Connected := False;
end;

end.
