{
   Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, DBXpress, FMTBcd, DB, SqlExpr;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    ListView: TListView;
    Memo: TMemo;
    btnNew: TButton;
    btnReply: TButton;
    btnUpdate: TButton;
    MySQL: TSQLConnection;
    SQL: TSQLDataSet;
    procedure btnUpdateClick(Sender: TObject);
    procedure ListViewClick(Sender: TObject);
    procedure btnNewClick(Sender: TObject);
    procedure btnReplyClick(Sender: TObject);
  private
    Entries : array of String;
    Addresses : array of String;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

uses DateUtils, ReplyFrm;

procedure TMainForm.btnUpdateClick(Sender: TObject);
var
  lUpdate : Int64;
  TF : TextFile;
  i : Integer;
  ListItem : TListItem;
begin
  Entries := nil; // destrukcja tablicy
  ListView.Clear;

  { jeeli znajdzie si plik last_avtive - odczytaj z niego dane }
  if FileExists('last_active') then
  begin
    AssignFile(TF, 'last_active');
    try
      Reset(TF);
      Readln(TF, lUpdate);
    finally
      CloseFile(TF);
    end;
  end else lUpdate := 0;

  { zapytanie SQL }
  SQL.CommandText := Format('SELECT * FROM guests where time>%d', [lUpdate]);
  SQL.Open;

  SetLength(Entries, SQL.RecordCount); // ilo znalezionych rekordw
  SetLength(Addresses, SQL.RecordCount); // ilo znalezionych rekordw

  for I := 0 to SQL.RecordCount -1 do
  begin
  { dodaj now pozycj }
    ListItem := ListView.Items.Add;
    ListItem.Caption := SQL.FieldValues['id'];
    ListItem.SubItems.Add(SQL.FieldValues['nick']);
    ListItem.SubItems.Add(DateTimeToStr(UnixToDateTime(SQL.FieldValues['time'])));
    Entries[i] := SQL.FieldValues['message'];  // tre wiadomoci do tablicy...
    Addresses[i] := SQL.FieldValues['mail'];
    SQL.Next;
  end;

  SQL.Close;

  { zapisz do pliku dat ostatniego cigania }
  AssignFile(TF, 'last_active');
  ReWrite(TF);
  Writeln(TF, DateTimeToUnix(Now));
  CloseFile(TF);

  
end;

procedure TMainForm.ListViewClick(Sender: TObject);
begin
  Memo.Clear;
  Memo.Lines.Text := ListView.Selected.SubItems[0] + ' <' + Addresses[ListView.Selected.Index] + '> napisa: ';
  Memo.Lines.Add(Entries[ListView.Selected.Index]);
end;

procedure TMainForm.btnNewClick(Sender: TObject);
begin
  ReplyForm := TReplyForm.Create(Application);
  ReplyForm.ShowModal;
  ReplyForm.Free;
end;

procedure TMainForm.btnReplyClick(Sender: TObject);
begin
  ReplyForm := TReplyForm.Create(Application);
  ReplyForm.Memo.Lines.Text := 'Do: ' + ListView.Selected.SubItems[0];
  ReplyForm.ShowModal;
  ReplyForm.Free;
end;

end.
