{
  Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}


unit ActiveWWWFrm;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ActiveX, AxCtrls, ActiveWWWProj_TLB, StdVcl, StdCtrls;

type
  TActiveWWW = class(TActiveForm, IActiveWWW)
    GroupBox1: TGroupBox;
    lblMessage: TLabel;
    btnGo: TButton;
    btnStop: TButton;
    procedure btnGoClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
  private
    { Private declarations }
    FEvents: IActiveWWWEvents;
    procedure ActivateEvent(Sender: TObject);
    procedure ClickEvent(Sender: TObject);
    procedure CreateEvent(Sender: TObject);
    procedure DblClickEvent(Sender: TObject);
    procedure DeactivateEvent(Sender: TObject);
    procedure DestroyEvent(Sender: TObject);
    procedure KeyPressEvent(Sender: TObject; var Key: Char);
    procedure PaintEvent(Sender: TObject);
  protected
    { Protected declarations }
    procedure DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage); override;
    procedure EventSinkChanged(const EventSink: IUnknown); override;
    function Get_Active: WordBool; safecall;
    function Get_AlignDisabled: WordBool; safecall;
    function Get_AutoScroll: WordBool; safecall;
    function Get_AutoSize: WordBool; safecall;
    function Get_AxBorderStyle: TxActiveFormBorderStyle; safecall;
    function Get_Caption: WideString; safecall;
    function Get_Color: OLE_COLOR; safecall;
    function Get_DoubleBuffered: WordBool; safecall;
    function Get_DropTarget: WordBool; safecall;
    function Get_Enabled: WordBool; safecall;
    function Get_Font: IFontDisp; safecall;
    function Get_HelpFile: WideString; safecall;
    function Get_KeyPreview: WordBool; safecall;
    function Get_PixelsPerInch: Integer; safecall;
    function Get_PrintScale: TxPrintScale; safecall;
    function Get_Scaled: WordBool; safecall;
    function Get_ScreenSnap: WordBool; safecall;
    function Get_SnapBuffer: Integer; safecall;
    function Get_Visible: WordBool; safecall;
    function Get_VisibleDockClientCount: Integer; safecall;
    procedure _Set_Font(var Value: IFontDisp); safecall;
    procedure Set_AutoScroll(Value: WordBool); safecall;
    procedure Set_AutoSize(Value: WordBool); safecall;
    procedure Set_AxBorderStyle(Value: TxActiveFormBorderStyle); safecall;
    procedure Set_Caption(const Value: WideString); safecall;
    procedure Set_Color(Value: OLE_COLOR); safecall;
    procedure Set_DoubleBuffered(Value: WordBool); safecall;
    procedure Set_DropTarget(Value: WordBool); safecall;
    procedure Set_Enabled(Value: WordBool); safecall;
    procedure Set_Font(const Value: IFontDisp); safecall;
    procedure Set_HelpFile(const Value: WideString); safecall;
    procedure Set_KeyPreview(Value: WordBool); safecall;
    procedure Set_PixelsPerInch(Value: Integer); safecall;
    procedure Set_PrintScale(Value: TxPrintScale); safecall;
    procedure Set_Scaled(Value: WordBool); safecall;
    procedure Set_ScreenSnap(Value: WordBool); safecall;
    procedure Set_SnapBuffer(Value: Integer); safecall;
    procedure Set_Visible(Value: WordBool); safecall;
  public
    { Public declarations }
    procedure Initialize; override;
  end;

implementation

uses ComObj, ComServ;

{$R *.DFM}

{ TActiveWWW }

procedure TActiveWWW.DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage);
begin
  { Define property pages here.  Property pages are defined by calling
    DefinePropertyPage with the class id of the page.  For example,
      DefinePropertyPage(Class_ActiveWWWPage); }
end;

procedure TActiveWWW.EventSinkChanged(const EventSink: IUnknown);
begin
  FEvents := EventSink as IActiveWWWEvents;
  inherited EventSinkChanged(EventSink);
end;

procedure TActiveWWW.Initialize;
begin
  inherited Initialize;
  OnActivate := ActivateEvent;
  OnClick := ClickEvent;
  OnCreate := CreateEvent;
  OnDblClick := DblClickEvent;
  OnDeactivate := DeactivateEvent;
  OnDestroy := DestroyEvent;
  OnKeyPress := KeyPressEvent;
  OnPaint := PaintEvent;
end;

function TActiveWWW.Get_Active: WordBool;
begin
  Result := Active;
end;

function TActiveWWW.Get_AlignDisabled: WordBool;
begin
  Result := AlignDisabled;
end;

function TActiveWWW.Get_AutoScroll: WordBool;
begin
  Result := AutoScroll;
end;

function TActiveWWW.Get_AutoSize: WordBool;
begin
  Result := AutoSize;
end;

function TActiveWWW.Get_AxBorderStyle: TxActiveFormBorderStyle;
begin
  Result := Ord(AxBorderStyle);
end;

function TActiveWWW.Get_Caption: WideString;
begin
  Result := WideString(Caption);
end;

function TActiveWWW.Get_Color: OLE_COLOR;
begin
  Result := OLE_COLOR(Color);
end;

function TActiveWWW.Get_DoubleBuffered: WordBool;
begin
  Result := DoubleBuffered;
end;

function TActiveWWW.Get_DropTarget: WordBool;
begin
  Result := DropTarget;
end;

function TActiveWWW.Get_Enabled: WordBool;
begin
  Result := Enabled;
end;

function TActiveWWW.Get_Font: IFontDisp;
begin
  GetOleFont(Font, Result);
end;

function TActiveWWW.Get_HelpFile: WideString;
begin
  Result := WideString(HelpFile);
end;

function TActiveWWW.Get_KeyPreview: WordBool;
begin
  Result := KeyPreview;
end;

function TActiveWWW.Get_PixelsPerInch: Integer;
begin
  Result := PixelsPerInch;
end;

function TActiveWWW.Get_PrintScale: TxPrintScale;
begin
  Result := Ord(PrintScale);
end;

function TActiveWWW.Get_Scaled: WordBool;
begin
  Result := Scaled;
end;

function TActiveWWW.Get_ScreenSnap: WordBool;
begin
  Result := ScreenSnap;
end;

function TActiveWWW.Get_SnapBuffer: Integer;
begin
  Result := SnapBuffer;
end;

function TActiveWWW.Get_Visible: WordBool;
begin
  Result := Visible;
end;

function TActiveWWW.Get_VisibleDockClientCount: Integer;
begin
  Result := VisibleDockClientCount;
end;

procedure TActiveWWW._Set_Font(var Value: IFontDisp);
begin
  SetOleFont(Font, Value);
end;

procedure TActiveWWW.ActivateEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnActivate;
end;

procedure TActiveWWW.ClickEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnClick;
end;

procedure TActiveWWW.CreateEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnCreate;
end;

procedure TActiveWWW.DblClickEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnDblClick;
end;

procedure TActiveWWW.DeactivateEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnDeactivate;
end;

procedure TActiveWWW.DestroyEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnDestroy;
end;

procedure TActiveWWW.KeyPressEvent(Sender: TObject; var Key: Char);
var
  TempKey: Smallint;
begin
  TempKey := Smallint(Key);
  if FEvents <> nil then FEvents.OnKeyPress(TempKey);
  Key := Char(TempKey);
end;

procedure TActiveWWW.PaintEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnPaint;
end;

procedure TActiveWWW.Set_AutoScroll(Value: WordBool);
begin
  AutoScroll := Value;
end;

procedure TActiveWWW.Set_AutoSize(Value: WordBool);
begin
  AutoSize := Value;
end;

procedure TActiveWWW.Set_AxBorderStyle(Value: TxActiveFormBorderStyle);
begin
  AxBorderStyle := TActiveFormBorderStyle(Value);
end;

procedure TActiveWWW.Set_Caption(const Value: WideString);
begin
  Caption := TCaption(Value);
end;

procedure TActiveWWW.Set_Color(Value: OLE_COLOR);
begin
  Color := TColor(Value);
end;

procedure TActiveWWW.Set_DoubleBuffered(Value: WordBool);
begin
  DoubleBuffered := Value;
end;

procedure TActiveWWW.Set_DropTarget(Value: WordBool);
begin
  DropTarget := Value;
end;

procedure TActiveWWW.Set_Enabled(Value: WordBool);
begin
  Enabled := Value;
end;

procedure TActiveWWW.Set_Font(const Value: IFontDisp);
begin
  SetOleFont(Font, Value);
end;

procedure TActiveWWW.Set_HelpFile(const Value: WideString);
begin
  HelpFile := String(Value);
end;

procedure TActiveWWW.Set_KeyPreview(Value: WordBool);
begin
  KeyPreview := Value;
end;

procedure TActiveWWW.Set_PixelsPerInch(Value: Integer);
begin
  PixelsPerInch := Value;
end;

procedure TActiveWWW.Set_PrintScale(Value: TxPrintScale);
begin
  PrintScale := TPrintScale(Value);
end;

procedure TActiveWWW.Set_Scaled(Value: WordBool);
begin
  Scaled := Value;
end;

procedure TActiveWWW.Set_ScreenSnap(Value: WordBool);
begin
  ScreenSnap := Value;
end;

procedure TActiveWWW.Set_SnapBuffer(Value: Integer);
begin
  SnapBuffer := Value;
end;

procedure TActiveWWW.Set_Visible(Value: WordBool);
begin
  Visible := Value;
end;

var FBroken : Boolean;

procedure TActiveWWW.btnGoClick(Sender: TObject);
const
  ExMsg = 'To jest przykadowa kontrolka :-)';
var
  i : Integer;
begin
{ ptla while wykonywana przez cay czas trwania programu }
  while (not Application.Terminated) or (not FBroken) do
  begin
    lblMessage.Caption := '';
  { ptla for powoduje wywietlenie na etykiecie kolejnych liter }
    for i := 1 to Length(ExMsg) do
    begin
      Application.ProcessMessages;
      if FBroken then Break;
      Sleep(100);
      lblMessage.Caption := lblMessage.Caption + ExMsg[i];
    end;
  end;
end;

procedure TActiveWWW.btnStopClick(Sender: TObject);
begin
  FBroken := True;
end;

initialization
  TActiveFormFactory.Create(
    ComServer,
    TActiveFormControl,
    TActiveWWW,
    Class_ActiveWWW,
    1,
    '',
    OLEMISC_SIMPLEFRAME or OLEMISC_ACTSLIKELABEL,
    tmApartment);
end.
