{
  Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, StrUtils, IdBaseComponent,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP, ImgList, ShellAPI,
  IdAntiFreezeBase, IdAntiFreeze;

type
  TMatch = array of String;
  
  TMainForm = class(TForm)
    StatusBar: TStatusBar;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtQ: TEdit;
    btnSearch: TBitBtn;
    GroupBox2: TGroupBox;
    ListView: TListView;
    HTTP: TIdHTTP;
    ImageList1: TImageList;
    IdAntiFreeze: TIdAntiFreeze;
    procedure HTTPConnected(Sender: TObject);
    procedure HTTPDisconnected(Sender: TObject);
    procedure btnSearchClick(Sender: TObject);
    procedure ListViewInfoTip(Sender: TObject; Item: TListItem;
      var InfoTip: String);
    procedure edtQKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edtQClick(Sender: TObject);
  private
    anTitle : TMatch;
    anURL : TMatch;
    anBody : TMatch;
    function Ereg(var Body : String; Pattern : String) : TMatch;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

{ TMainForm }

function TMainForm.Ereg(var Body: String; Pattern: String): TMatch;
var
  Offset : Integer;
  Counter : Integer;
  APattern : array[0..1] of String;
  BeginPos, EndPos : Integer;
begin
  Offset := 1; // pozycja ostatnio znalezionej wartoci
  Counter := 1;

  { oddzielenie dwch elementw na podstawie znaku | }
  APattern[0] := Copy(Pattern, 0, Pos('|', Pattern) -1);
  APattern[1] := Copy(Pattern, Pos('|', Pattern)+1, Length(Pattern));

  while (PosEx(APattern[0], Body, Offset) > 0) do  // szukamy pierwszego czonu
  begin
    SetLength(Result, Counter);  // okrelamy wielko tablicy

    { okrelenie pocztkowej pozycji szukanego okrelenia }
    BeginPos := PosEx(APattern[0], Body, Offset) + Length(APattern[0]);
    { okrelenie kocowej pozycji szukanego okrelenia }
    EndPos := PosEx(APattern[1], Body, Offset);
    Offset := EndPos+1; // do zmiennej przypisywana jest pozycja ostatnio znalezionej wartoci

    // wycignicie treci pomidzy np. znakami <!--TITLE--> i <!--/TITLE-->
    Result[Counter-1] := Copy(Body, BeginPos, EndPos - BeginPos);

    Inc(Counter);  // zwikszenie licznika
  end;
end;

procedure TMainForm.HTTPConnected(Sender: TObject);
begin
  btnSearch.Enabled := False;
  StatusBar.SimpleText := 'Poczono z serwerem 4programmers.net...';
end;

procedure TMainForm.HTTPDisconnected(Sender: TObject);
begin
  btnSearch.Enabled := True;
  StatusBar.SimpleText := 'Rozczono z serwerem 4programmers.net...';
end;

function Convert(Src: String): String;
begin
  Src := StringReplace(Src,Chr(182),Chr(156), [rfReplaceAll]);
  Src := StringReplace(Src,Chr(177),Chr(185), [rfReplaceAll]);
  Src := StringReplace(Src,Chr(188),Chr(159), [rfReplaceAll]);
  Src := StringReplace(Src,'<span style="background-color: #C0C0C0">', '', [rfReplaceAll]);
  Src := StringReplace(Src,'</span>', '', [rfReplaceAll]);
  Src := StringReplace(Src,'&lt','<', [rfReplaceAll]);
  Src := StringReplace(Src,'&gt','>', [rfReplaceAll]);
  Result := Src;
end;

procedure TMainForm.btnSearchClick(Sender: TObject);
var
  HTML : String;
  I : Integer;
  TitleItem : TListItem;
begin
  HTTP.Host := '4programmers.net';
  HTTP.Connect; // czenie...
  try
    try
    { wyczyszczenie tablic }
      anTitle := nil;
      anURL := nil;
      anBody := nil;
      ListView.Clear; // wyczyszczenie Listview'a

      StatusBar.SimpleText := 'Trwa wyszukiwanie...';

    { pobieranie rezultatu poszukiwa }
      HTML := HTTP.Get('http://4programmers.net/search.php?Q=' + edtQ.Text);
      anTitle := Ereg(HTML, '<!--TITLE-->|<!--/TITLE-->'); // wycignicie tytuw
      anURL := Ereg(HTML, '<!--URL-->|<!--/URL-->');
      anBody := Ereg(HTML, '<!--BODY-->|<!--/BODY-->');

      if High(anTitle) = -1 then MessageBox(Handle, 'Niestety nie znaleziono adnej strony odpowiadajcej Twojemu zapytaniu!', ':-(', MB_ICONINFORMATION);
      
    { ptla po wszystkich znalezionych stronach }
      for I := 0 to High(anTitle) do
      begin
        TitleItem := ListView.Items.Add; // dodanie do komponentu
        TitleItem.ImageIndex := 0; // numer ikony ozdabiajcej dan pozycj
        TitleItem.Caption := Convert(anTitle[i]); // dodanie tytuu strony (po konwersji)
        TitleItem.SubItems.Add(Convert(anBody[i])); // opis strony do drugiej kolumny
      end;
    except
      raise;
    end;
  finally
    HTTP.Disconnect;
  end;
end;

procedure TMainForm.ListViewInfoTip(Sender: TObject; Item: TListItem;
  var InfoTip: String);
begin
// dymek podpowiedzi...
  InfoTip := Convert(anBody[Item.Index]);
end;

procedure TMainForm.edtQKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
// po nacinieciu klawisza Enter rozpocznij wyszukiwanie
  if Key = vk_Return then btnSearchClick(Sender);
end;

procedure TMainForm.edtQClick(Sender: TObject);
begin
// otwrz stron internetow
  ShellExecute(Handle, 'open', PChar(anURL[ListView.Selected.Index]), nil, nil, Sw_Show);
end;

end.
