{
  Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, IdMessage, IdBaseComponent, IdComponent,
  IdTCPConnection, IdTCPClient, IdMessageClient, IdSMTP, StdCtrls, Buttons;

type
  TMainForm = class(TForm)
    SMTP: TIdSMTP;
    Message: TIdMessage;
    StatusBar: TStatusBar;
    GroupBox1: TGroupBox;
    lblFrom: TLabel;
    edtFrom: TEdit;
    lblTo: TLabel;
    edtTo: TEdit;
    lblSubject: TLabel;
    edtSubject: TEdit;
    lblBody: TLabel;
    memBody: TMemo;
    btnSend: TSpeedButton;
    GroupBox2: TGroupBox;
    lblHost: TLabel;
    edtHost: TEdit;
    lblPort: TLabel;
    edtPort: TEdit;
    lblLogin: TLabel;
    lblPassword: TLabel;
    edtLogin: TEdit;
    edtPassword: TEdit;
    procedure SMTPConnected(Sender: TObject);
    procedure SMTPDisconnected(Sender: TObject);
    procedure SMTPStatus(ASender: TObject; const AStatus: TIdStatus;
      const AStatusText: String);
    procedure btnSendClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.SMTPConnected(Sender: TObject);
begin
  GroupBox1.Enabled := False;
  GroupBox2.Enabled := False;
end;

procedure TMainForm.SMTPDisconnected(Sender: TObject);
begin
  GroupBox1.Enabled := True;
  GroupBox2.Enabled := True;
end;

procedure TMainForm.SMTPStatus(ASender: TObject; const AStatus: TIdStatus;
  const AStatusText: String);
begin
  case AStatus of
    hsResolving: StatusBar.SimpleText := 'Wyszukiwanie hosta...';
    hsConnecting: StatusBar.SimpleText := 'czenie z serwerem ' + SMTP.Host;
    hsConnected: StatusBar.SimpleText := 'Poczony z serwerem';
    hsDisconnecting: StatusBar.SimpleText := 'Trwa rozczanie...';
    hsDisconnected: StatusBar.SimpleText := 'Rozczono';
  end;
end;

procedure TMainForm.btnSendClick(Sender: TObject);
begin
  SMTP.Host := 'mail.moj-serwer.com';
  try
    SMTP.Connect;
  except
    raise Exception.Create('Niestety serwer, z ktrym prbujesz si poczy nie odpowiada!');
  end;

  SMTP.Disconnect;
end;

end.
