{
   Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}
unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, ValEdit;

type
  TMainForm = class(TForm)
    vleSystemInfo: TValueListEditor;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}


  
procedure TMainForm.FormCreate(Sender: TObject);
var
  SystemInfo : TSystemInfo;
begin
  GetSystemInfo(SystemInfo);
  with vleSystemInfo do
  begin
    InsertRow('Architektura procesora', 'Intel', True);
    InsertRow('Rozmiar strony', InttoStr(SystemInfo.dwPageSize) + ' bajtw', True);
    InsertRow('Min. adres aplikacji', Format('%p', [SystemInfo.lpMinimumApplicationAddress]), True);
    InsertRow('Max. adres aplikacji', Format('%p', [SystemInfo.lpMaximumApplicationAddress]), True);
    InsertRow('Liczba procesorw', IntToStr(SystemInfo.dwNumberOfProcessors), True);
    InsertRow('Granulacja przydziau', IntToStr(SystemInfo.dwAllocationGranularity) + ' bajtw', True);
    InsertRow('Typ procesora', 'klasa ' + IntToStr(systemInfo.dwProcessorType), True);
        
  end;
end;

end.
