{
   Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}
unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, ValEdit;

type
  TMainForm = class(TForm)
    vleMemoryStatus: TValueListEditor;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

 
procedure TMainForm.FormCreate(Sender: TObject);
var
  MS : TMemoryStatus;
begin
  MS.dwLength := SizeOf(MS);  // okrelenie wielkoci rekordu
  GlobalMemoryStatus(MS); // pobierz informacj

  with vleMemoryStatus do
  begin
    InsertRow('Procent pamici uywanej', IntToStr(MS.dwMemoryLoad) + '%', True);
    InsertRow('Cakowita pami fizyczna', IntToStr(MS.dwTotalPhys div 1024) + ' kB', True);
    InsertRow('Wolna pami fizyczna', IntToStr(MS.dwAvailPhys div 1024) + ' kB', True);
    InsertRow('Pojemno pliku wymiany', IntToStr(MS.dwTotalPageFile div 1024) + ' kB', True);
    InsertRow('Wolna pami w pliku wymiany', IntToStr(MS.dwAvailPageFile div 1024) + ' kB', True);
    InsertRow('Pami wirtualna', IntToStr(MS.dwTotalVirtual div 1024) + ' kB', True);
    InsertRow('Wolna pami wirtualna', IntToStr(MS.dwAvailVirtual div 1024) + ' kB', True);
  end;

end;

end.
