unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, ComCtrls;

type
  TMainForm = class(TForm)
    imgIcons: TImageList;
    ListView: TListView;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var                  
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.FormCreate(Sender: TObject);
var
  i : Integer;
  Drive_Type : Integer;
  ListItem : TListItem;
  Volume : array[0..255] of char;
  MaxComponentLength, Flag : DWORD;
  SectorsPerClusters, BytesPerSector,
      FreeClusters, TotalClusters : DWORD;
  DriveByte : Byte;
begin

{ ptla po wszystkich literach }
  for I := Ord('A') to Ord('Z') do
  begin
  // uzyskanie litery dysku
    Drive_Type := GetDriveType(PChar(Chr(i) + ':\'));
    if (Drive_Type <> 0) and (Drive_Type <> 1) then
    begin
    { pobranie etykiety }
      GetVolumeInformation(PChar(Chr(i) + ':\'), Volume, SizeOf(Volume), nil, MaxComponentLength, Flag, nil, 0);

      ListItem := ListView.Items.Add;
      if Volume = '' then Volume := 'BRAK';
      ListItem.Caption := Chr(i) + ':\ (' + Volume + ')';  // wywietlenie litery i etykiety dysku

    { pobieranie dodatkowych informacji do do dyskw }  
      GetDiskFreeSpace(PChar(Chr(i) + ':\'), SectorsPerClusters, BytesPerSector,
      FreeClusters, TotalClusters);

      ListItem.SubItems.Add(IntToStr(SectorsPerClusters));
      ListItem.SubItems.Add(IntToStr(BytesPerSector));
      ListItem.SubItems.Add(IntToStr(FreeClusters));
      ListItem.SubItems.Add(IntToStr(TotalClusters));

      { numer dysku }
      DriveByte := (i - Ord('A') + 1);

      { dodanie do komponentu danych (w kB) }
      ListItem.SubItems.Add(IntToStr(DiskSize(DriveByte) div 1024) + ' kB');
      ListItem.SubItems.Add(IntToStr(DiskFree(DriveByte) div 1024) + ' kB');


      case Drive_Type of
      { w zalenoci od rodzaju dysku - wywietl ikone }
        DRIVE_CDROM: ListItem.ImageIndex := 0;
        DRIVE_FIXED: ListItem.ImageIndex := 1;
        else ListItem.ImageIndex := -1;
      end;
    end;
  end;
end;

end.
