{
   Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}
unit ThreadFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls;

type
  TThreadForm = class(TForm)
    lvThreads: TListView;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public

  end;

var
  ThreadForm: TThreadForm;

implementation

{$R *.dfm}

uses TlHelp32, MainFrm;

procedure TThreadForm.FormCreate(Sender: TObject);
var
  TE : TThreadEntry32;
  ListItem : TListItem;
begin

  Te.dwSize := SizeOf(TE); // okrel rozmiar struktury
  if Thread32First(MainForm.SnapShot, TE) then
  begin

    while Thread32Next(MainForm.SnapShot, TE) do
    begin
      if IntToHex(TE.th32OwnerProcessID, 8) = (MainForm.lvProcess.Selected.SubItems[0]) then
      begin
        ListItem := lvThreads.Items.Add;
        ListItem.Caption := IntToHex(TE.th32ThreadID, 8);
        ListItem.SubItems.Add(IntToHex(TE.th32OwnerProcessID, 8));
        case TE.tpBasePri of
          4: ListItem.SubItems.Add('Idle');
          8: ListItem.SubItems.Add('Normal');
          13: ListItem.SubItems.Add('High');
          24: ListItem.SubItems.Add('ReadlTime');
        end;

      end;
    end;
  end;
end;

end.
