{
   Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}
unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, ValEdit, TlHelp32, ImgList, ComCtrls, ShellAPI;

type
  TMainForm = class(TForm)
    lvProcess: TListView;
    imgList: TImageList;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}


procedure TMainForm.FormCreate(Sender: TObject);
var
  PE : TProcessEntry32;
  SnapShot : THandle;
  ListItem : TListItem;
  Icon : TIcon;
begin
{ zrzut systemowy }
  SnapShot := CreateToolHelp32Snapshot(TH32CS_SNAPPROCESS, 0);
  PE.dwSize := SizeOf(PE); // okrela rozmiar rekordu

  Icon := TIcon.Create;

  if Process32First(SnapShot, PE) then
  begin
  { ptla }
    while Process32Next(SnapShot, PE) do
    begin

      ListItem := lvProcess.Items.Add;
      ListItem.Caption := IntToStr(PE.cntUsage);
      ListItem.SubItems.Add(IntToStr(PE.th32ProcessID));
      ListItem.SubItems.Add(IntToStr(PE.cntThreads));
      ListItem.SubItems.Add(IntToStr(PE.th32ParentProcessID));
      ListItem.SubItems.Add(PE.szExeFile);

      { "wycignicie" ikony }
      Icon.Handle := ExtractIcon(hInstance, PE.szExeFile, 0);
      imgList.AddIcon(Icon); // dodanie ikon
      ListItem.ImageIndex := imgList.Count -1; // ustawienie numeru ikony


    end;
  end;
  Icon.Free;
end;

end.
