{
  Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DBXpress, DB, SqlExpr, StdCtrls, FMTBcd, Grids, ValEdit,
  ComCtrls;

type
  TMainForm = class(TForm)
    MySQL: TSQLConnection;
    btnConnect: TButton;
    SQL: TSQLDataSet;
    ListView: TListView;
    btnDelete: TButton;
    procedure btnConnectClick(Sender: TObject);
    procedure MySQLAfterConnect(Sender: TObject);
    procedure MySQLAfterDisconnect(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnDeleteClick(Sender: TObject);
  private
    Connected : Boolean;
    procedure LoadTable;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.btnConnectClick(Sender: TObject);
begin
  if Connected then Connected := False else Connected := True;
  MySQL.Connected := Connected;
end;

procedure TMainForm.MySQLAfterConnect(Sender: TObject);
begin
  btnConnect.Caption := 'Rozcz';
  btnDelete.Enabled := True;
  LoadTable;
end;

procedure TMainForm.MySQLAfterDisconnect(Sender: TObject);
begin
  btnConnect.Caption := 'Pocz';
  btnDelete.Enabled := False;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
// podczas zamknicia programu - rozczenie z serwerem
  MySQL.Connected := False;
end;

procedure TMainForm.LoadTable;
var
  i : Integer;
  ListItem : TListItem;
begin
  ListView.Items.Clear;
  SQL.CommandText := 'SELECT * FROM users'; // zapytanie
  SQL.Open; // odczytaj dane

  for I := 1 to SQL.RecordCount do
  begin
  { dodaj kolejne wartoci }
    ListItem := ListView.Items.Add;
    ListItem.Caption := IntToStr(SQL.FieldValues['id']);
    ListItem.SubItems.Add(SQL.FieldValues['name']);
    ListItem.SubItems.Add(SQL.FieldValues['mail']);
    SQL.Next;
  end;

  SQL.Close;
end;

procedure TMainForm.btnDeleteClick(Sender: TObject);
begin
  SQL.CommandText := Format('DELETE FROM users where id="%s"', [ListView.Selected.Caption]);
  SQL.ExecSQL(True);
  LoadTable; // po wykonaniu zapytania - wywoaj procedur
end;

end.
