{
  Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Sockets, StdCtrls, IdTCPConnection, IdTCPClient,
  IdBaseComponent, IdComponent, IdTCPServer;

type
  TMainForm = class(TForm)
    btnConnect: TButton;
    edtIP: TEdit;
    lblIP: TLabel;
    GroupBox1: TGroupBox;
    Memo: TMemo;
    ServerChecked: TCheckBox;
    Client: TIdTCPClient;
    Server: TIdTCPServer;
    CmdBox: TListBox;
    procedure ServerConnect(AThread: TIdPeerThread);
    procedure ServerDisconnect(AThread: TIdPeerThread);
    procedure btnConnectClick(Sender: TObject);
    procedure ServerCheckedClick(Sender: TObject);
    procedure ClientConnect(Sender: TObject);
    procedure ClientDisconnect(Sender: TObject);
    procedure ServerHelloCmdCommand(ASender: TIdCommand);
    procedure CmdBoxClick(Sender: TObject);
    procedure ServerWndDirCmdCommand(ASender: TIdCommand);
  private

  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;


implementation

{$R *.dfm}

procedure TMainForm.ServerConnect(AThread: TIdPeerThread);
begin
  Memo.Lines.Add('Klient poczony...');
end;

procedure TMainForm.ServerDisconnect(AThread: TIdPeerThread);
begin
  Memo.Lines.Add('Klient rozczony...');
end;

procedure TMainForm.btnConnectClick(Sender: TObject);
begin
  if Client.Connected then  // w przypadku, gdy zawarte jest poczenie...
  begin
    Client.Disconnect; //...rozcz z serwerem
    btnConnect.Caption := 'Pocz z komputerem';
  end else
  begin   //...w przeciwnym wypadku...
    Server.Active := False; //...dezaktywuj serwer...
    Client.Host := edtIP.Text; //...pobierz IP z kontrolki
    Client.Connect; //...pocz
    btnConnect.Caption := 'Rozcz';
  end;
end;

procedure TMainForm.ServerCheckedClick(Sender: TObject);
begin
// aktywuj serwer, w razie, gdy pozycja jest zaznaczona
  Server.Active := ServerChecked.Checked;
end;

procedure TMainForm.ClientConnect(Sender: TObject);
begin
  Memo.Lines.Add('Poczony...'); // informcja, w komponencie Memo
end;

procedure TMainForm.ClientDisconnect(Sender: TObject);
begin
  Memo.Lines.Add('Rozczony...');  // informacja, w komponencie Memo
end;

procedure TMainForm.ServerHelloCmdCommand(ASender: TIdCommand);
begin
  ASender.SendReply; // wylij odpowied
  Memo.Lines.Add('Otrzymaem polecenie "HELLO"'); // w Memo wywietl informacje, o otrzymaniu komendy
end;

procedure TMainForm.CmdBoxClick(Sender: TObject);
begin
  Client.SendCmd(CmdBox.Items[CmdBox.ItemIndex]); // wysanie komendy
  { wywietlenie rezultatu w komponencie Memo }
  Memo.Lines.Add(Client.LastCmdResult.TextCode + '-' + Client.LastCmdResult.Text.Text);
end;

procedure TMainForm.ServerWndDirCmdCommand(ASender: TIdCommand);

{ zagniedona funkcja GetWDir podajca ciek do systemu Windows }
  function GetWDir : String;
  var
    Buffer : array[0..128] of char;
  begin
    GetWindowsDirectory(Buffer, SizeOf(Buffer));
    Result := Buffer;
  end;
  
begin
  ASender.Reply.NumericCode := 200;
  ASender.Reply.TextCode := '200';
  ASender.Reply.Text.Text := GetWDir;
  ASender.SendReply;
  Memo.Lines.Add('Otrzymaem polecenie "WINDOWS"'); // w Memo wywietl informacje, o otrzymaniu komendy
end;

end.
