{
  Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, StrUtils, IdBaseComponent,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP, ImgList;

type
  TMatch = array of String;
  
  TMainForm = class(TForm)
    StatusBar: TStatusBar;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtQ: TEdit;
    btnSearch: TBitBtn;
    GroupBox2: TGroupBox;
    ListView: TListView;
    HTTP: TIdHTTP;
    ImageList1: TImageList;
    procedure HTTPConnected(Sender: TObject);
    procedure HTTPDisconnected(Sender: TObject);
    procedure btnSearchClick(Sender: TObject);
  private
    anTitle : TMatch;
    function Ereg(var Body : String; Pattern : String) : TMatch;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

{ TMainForm }

function TMainForm.Ereg(var Body: String; Pattern: String): TMatch;
var
  Offset : Integer;
  Counter : Integer;
  APattern : array[0..1] of String;
  BeginPos, EndPos : Integer;
begin
  Offset := 1; // pozycja ostatnio znalezionej wartoci
  Counter := 1;

  { oddzielenie dwch elementw na podstawie znaku | }
  APattern[0] := Copy(Pattern, 0, Pos('|', Pattern) -1);
  APattern[1] := Copy(Pattern, Pos('|', Pattern)+1, Length(Pattern));

  while (PosEx(APattern[0], Body, Offset) > 0) do  // szukamy pierwszego czonu
  begin
    SetLength(Result, Counter);  // okrelamy wielko tablicy

    { okrelenie pocztkowej pozycji szukanego okrelenia }
    BeginPos := PosEx(APattern[0], Body, Offset) + Length(APattern[0]);
    { okrelenie kocowej pozycji szukanego okrelenia }
    EndPos := PosEx(APattern[1], Body, Offset);
    Offset := EndPos+1; // do zmiennej przypisywana jest pozycja ostatnio znalezionej wartoci

    // wycignicie treci pomidzy np. znakami <!--TITLE--> i <!--/TITLE-->
    Result[Counter-1] := Copy(Body, BeginPos, EndPos - BeginPos);

    Inc(Counter);  // zwikszenie licznika
  end;
end;

procedure TMainForm.HTTPConnected(Sender: TObject);
begin
  btnSearch.Enabled := False;
  StatusBar.SimpleText := 'Poczono z serwerem 4programmers.net...';
end;

procedure TMainForm.HTTPDisconnected(Sender: TObject);
begin
  btnSearch.Enabled := True;
  StatusBar.SimpleText := 'Rozczono z serwerem 4programmers.net...';
end;

function Convert(Src: String): String;
begin
  Src := StringReplace(Src,Chr(182),Chr(156), [rfReplaceAll]);
  Src := StringReplace(Src,Chr(177),Chr(185), [rfReplaceAll]);
  Src := StringReplace(Src,Chr(188),Chr(159), [rfReplaceAll]);
  Result := Src;
end;

procedure TMainForm.btnSearchClick(Sender: TObject);
var
  HTML : String;
  I : Integer;
  TitleItem : TListItem;
begin
  HTTP.Host := '4programmers.net';
  HTTP.Connect; // czenie...
  try
    try
    { pobieranie rezultatu poszukiwa }
      HTML := HTTP.Get('http://4programmers.netsearch.php?Q=' + edtQ.Text);
      anTitle := Ereg(HTML, '<!--TITLE-->|<!--/TITLE-->'); // wycignicie tytuw
    { ptla po wszystkich znalezionych stronach }
      for I := 0 to High(anTitle) do
      begin
        TitleItem := ListView.Items.Add; // dodanie do komponentu
        TitleItem.ImageIndex := 0; // numer ikony ozdabiajcej dan pozycj
        TitleItem.Caption := Convert(anTitle[i]); // dodanie tytuu strony (po konwersji)
      end;
    except
      raise;
    end;
  finally
    HTTP.Disconnect;
  end;
end;

end.
