{
  Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, StrUtils;

type
  TMatch = array of String;
  
  TMainForm = class(TForm)
    StatusBar: TStatusBar;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtQ: TEdit;
    btnSearch: TBitBtn;
    GroupBox2: TGroupBox;
    ListView: TListView;
  private
    function Ereg(var Body : String; Pattern : String) : TMatch;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

{ TMainForm }

function TMainForm.Ereg(var Body: String; Pattern: String): TMatch;
var
  Offset : Integer;
  Counter : Integer;
  APattern : array[0..1] of String;
  BeginPos, EndPos : Integer;
begin
  Offset := 1; // pozycja ostatnio znalezionej wartoci
  Counter := 1;

  { oddzielenie dwch elementw na podstawie znaku | }
  APattern[0] := Copy(Pattern, 0, Pos('|', Pattern) -1);
  APattern[1] := Copy(Pattern, Pos('|', Pattern)+1, Length(Pattern));

  while (PosEx(APattern[0], Body, Offset) > 0) do  // szukamy pierwszego czonu
  begin
    SetLength(Result, Counter);  // okrelamy wielko tablicy

    { okrelenie pocztkowej pozycji szukanego okrelenia }
    BeginPos := PosEx(APattern[0], Body, Offset) + Length(APattern[0]);
    { okrelenie kocowej pozycji szukanego okrelenia }
    EndPos := PosEx(APattern[1], Body, Offset);
    Offset := EndPos+1; // do zmiennej przypisywana jest pozycja ostatnio znalezionej wartoci

    // wycignicie treci pomidzy np. znakami <!--TITLE--> i <!--/TITLE-->
    Result[Counter-1] := Copy(Body, BeginPos, EndPos - BeginPos);

    Inc(Counter);  // zwikszenie licznika
  end;
end;

end.
