{
  Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient,
  IdHTTP, StdCtrls;

type
  TMainForm = class(TForm)
    HTTP: TIdHTTP;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtFrom: TEdit;
    Label2: TLabel;
    memMsg: TMemo;
    btnSendMsg: TButton;
    procedure btnSendMsgClick(Sender: TObject);
    procedure HTTPConnected(Sender: TObject);
    procedure HTTPDisconnected(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.btnSendMsgClick(Sender: TObject);
var
  StreamIn, StreamOut : TStringStream;
begin
{ utworzenie strumieni }
  HTTP.Host := '4programmers.net';
  StreamIn := TStringStream.Create('');
  StreamOut := TStringStream.Create('');
  try
    StreamIn.WriteString(Format('message=%s&from=%s', [memMsg.Text, edtFrom.Text]));
    HTTP.Post('http://4programmers.net/mail.php', StreamIn, StreamOut); // wysanie zawartoci do skryptu
  { wywietlenie odpowiedzi jaka zostaa zwrcona przez skrypt }
    MessageBox(Handle, PChar(StreamOut.DataString), 'Wiadomo wysana :-)', MB_ICONINFORMATION);
  finally
  { zwolnienie zasobw }
    StreamIn.Free;
    StreamOut.Free;
  end;
end;

procedure TMainForm.HTTPConnected(Sender: TObject);
begin
  btnSendMsg.Enabled := False;
end;

procedure TMainForm.HTTPDisconnected(Sender: TObject);
begin
  btnSendMsg.Enabled := True;
end;

end.


