{
   Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient,
  IdHTTP, StdCtrls;

type
  TMainForm = class(TForm)
    HTTP: TIdHTTP;
    btnConnect: TButton;
    Label1: TLabel;
    edtIP: TEdit;
    GroupBox1: TGroupBox;
    memHTML: TMemo;
    procedure btnConnectClick(Sender: TObject);
    procedure HTTPConnected(Sender: TObject);
    procedure HTTPDisconnected(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.btnConnectClick(Sender: TObject);
begin
  HTTP.Host := edtIP.Text; // przypisanie nazwy hosta
  HTTP.Connect; // poczenie
  memHTML.Lines.Text := HTTP.Get('http://' + edtIP.Text + '/index.html');
  HTTP.Disconnect; // rozczenie
end;

procedure TMainForm.HTTPConnected(Sender: TObject);
begin
  MessageBox(Handle, 'Uzyskano poczenie!', ':-)', mb_OK);
end;

procedure TMainForm.HTTPDisconnected(Sender: TObject);
begin
  MessageBox(Handle, 'Rozczono z serwerem', ':-)', mb_OK);
end;

end.
