unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, ComCtrls;

type
  TMainForm = class(TForm)
    imgIcons: TImageList;
    ListView: TListView;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var                  
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.FormCreate(Sender: TObject);
var
  i : Integer;
  Drive_Type : Integer;
  ListItem : TListItem;
  Volume : array[0..255] of char;
  MaxComponentLength, Flag : DWORD;
begin
{ ptla po wszystkich literach }
  for I := Ord('A') to Ord('Z') do
  begin
  // uzyskanie litery dysku
    Drive_Type := GetDriveType(PChar(Chr(i) + ':\'));
    if (Drive_Type <> 0) and (Drive_Type <> 1) then
    begin
    { pobranie etykiety }
      GetVolumeInformation(PChar(Chr(i) + ':\'), Volume, SizeOf(Volume), nil, MaxComponentLength, Flag, nil, 0);

      ListItem := ListView.Items.Add;
      if Volume = '' then Volume := 'BRAK';
      ListItem.Caption := Chr(i) + ':\ (' + Volume + ')';  // wywietlenie litery i etykiety dysku

      case Drive_Type of
      { w zalenoci od rodzaju dysku - wywietl ikone }
        DRIVE_CDROM: ListItem.ImageIndex := 0;
        DRIVE_FIXED: ListItem.ImageIndex := 1;
        else ListItem.ImageIndex := -1;
      end;
    end;
  end;
end;

end.
