{
  Copyright (c) 2002 by Adam Boduch <adam@4programmers.net>
}

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, IdMessage, IdBaseComponent, IdComponent,
  IdTCPConnection, IdTCPClient, IdMessageClient, IdSMTP, StdCtrls, Buttons;

type
  TMainForm = class(TForm)
    SMTP: TIdSMTP;
    Message: TIdMessage;
    StatusBar: TStatusBar;
    GroupBox1: TGroupBox;
    lblFrom: TLabel;
    edtFrom: TEdit;
    lblTo: TLabel;
    edtTo: TEdit;
    lblSubject: TLabel;
    edtSubject: TEdit;
    lblBody: TLabel;
    memBody: TMemo;
    btnSend: TSpeedButton;
    GroupBox2: TGroupBox;
    lblHost: TLabel;
    edtHost: TEdit;
    lblPort: TLabel;
    edtPort: TEdit;
    lblLogin: TLabel;
    lblPassword: TLabel;
    edtLogin: TEdit;
    edtPassword: TEdit;
    procedure SMTPConnected(Sender: TObject);
    procedure SMTPDisconnected(Sender: TObject);
    procedure SMTPStatus(ASender: TObject; const AStatus: TIdStatus;
      const AStatusText: String);
    procedure btnSendClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.SMTPConnected(Sender: TObject);
begin
  GroupBox1.Enabled := False;
  GroupBox2.Enabled := False;
end;

procedure TMainForm.SMTPDisconnected(Sender: TObject);
begin
  GroupBox1.Enabled := True;
  GroupBox2.Enabled := True;
end;

procedure TMainForm.SMTPStatus(ASender: TObject; const AStatus: TIdStatus;
  const AStatusText: String);
begin
  case AStatus of
    hsResolving: StatusBar.SimpleText := 'Wyszukiwanie hosta...';
    hsConnecting: StatusBar.SimpleText := 'czenie z serwerem ' + SMTP.Host;
    hsConnected: StatusBar.SimpleText := 'Poczony z serwerem';
    hsDisconnecting: StatusBar.SimpleText := 'Trwa rozczanie...';
    hsDisconnected: StatusBar.SimpleText := 'Rozczono';
  end;
end;

procedure TMainForm.btnSendClick(Sender: TObject);
begin

 if Length(edtLogin.Text) > 0 then // Jeeli uytkownik wpisa login...
  begin
    SMTP.AuthenticationType := atLogin; //...znaczy to, e serwer wymaga autoryzacji
  { przypisanie waciwoci Username (uytkownik) oraz Password (haso) }
    SMTP.Username := edtLogin.Text;
    SMTP.Password := edtPassword.Text;
  end;

  SMTP.Host := edtHost.Text;  // przypisanie adresu
  SMTP.Port := StrToInt(edtPort.Text); // przypisanie IP

  try
    try
      SMTP.Connect; // prba poczenia si z serwerem
      btnSend.Enabled := False; // dezaktywacja przycisku

      Message.Subject := edtSubject.Text; // temat wiadomoci
      Message.From.Address := edtFrom.Text; // adres nadawcy
      Message.From.Text := edtFrom.Text;
      Message.From.Name := edtFrom.Text;

      
      Message.Recipients.Add;
      Message.Recipients.Items[0].Address := edtTo.Text; // adres odbiorcy
      Message.Recipients.Items[0].Text := edtTo.Text;
      Message.Recipients.Items[0].Name := edtTo.Text;
      
      Message.Body.Assign(memBody.Lines); // pobieranie treci wiadomoci

      SMTP.Send(Message); // wysyanie e-maila
    except
    { w razie wystpienia bdu - wywietl komunikat }
       raise Exception.Create('Bd! Nie mona poczy si z serwerem!');
    end;
  finally
  { te instrukcje bda wykonywane ZAWSZE bez wzgldu na ew. wystpienie bdu }
    btnSend.Enabled := True;
    SMTP.Disconnect;
  end;  

end;

end.
