// "C++. wiczenia zaawansowane", Andrzej Stasiewicz, Helion 2004

#include <iostream>
using namespace std;

class Wektor3d
{
 friend Wektor3d operator *( double r, const Wektor3d &w);
 friend ostream & operator << ( ostream &os, const Wektor3d &w);
 private:
    double x, y, z;
 public:
    Wektor3d( void) : x(0), y( 0), z(0){}
    Wektor3d( double x, double y, double z) : x( x), y( y), z( z){}
    Wektor3d operator -(void) 
    { 
     Wektor3d tmp( -x, -y, -z);
     return tmp;
    }
    Wektor3d operator +( Wektor3d w) 
    { 
     Wektor3d tmp( x + w.x, y + w.y, z + w.z);
     return tmp;
    }
    double operator *( Wektor3d w) 
    { 
     return ( x * w.x + y * w.y + z * w.z);
    }
    bool operator <( const Wektor3d &w) 
    { 
     double r1 = x * x + y * y + z * z;
     double r2 = w.x * w.x + w.y * w.y + w.z * w.z;
     return r1 < r2;
    }
    Wektor3d & operator =( const Wektor3d &w) 
    { 
     if( &w != this)
     {
//       cout << "Operator = przy pracy ..." << endl;
       x = w.x;
       y = w.y;
       z = w.z;
     }
     return *this;
    }
    Wektor3d operator *( double r) 
    { 
     Wektor3d tmp( x * r, y * r, z * r);
     return tmp;
    }
};
//------------------------------------------------
Wektor3d operator *( double r, const Wektor3d &w) 
{ 
 Wektor3d tmp( r * w.x, r * w.y, r * w.z);
 return tmp;
}
//------------------------------------------------
ostream & operator << ( ostream &os, const Wektor3d &w) 
{ 
 os << "[" << w.x << ", " << w.y << ", " << w.z << "]"; 
 return os;
}
//------------------------------------------------
int main()
{
 Wektor3d w( 1, 2, 3);
 double pi = 3.14;
 cout << "pi = " << pi << ", w = " << w << endl;
 cout << "w * pi = " << w * pi << endl;
 cout << "pi * w = " << pi * w << endl;
 char c;
 cin >> c;
}

