// "C++. wiczenia zaawansowane", Andrzej Stasiewicz, Helion 2004

#include <iostream>
using namespace std;
//------------------------------------------------
class Wektor3d
{
 private:
    double x, y, z;
 public:
    Wektor3d( void) : x(0), y( 0), z(0){}
    Wektor3d( double x, double y, double z) : x( x), y( y), z( z){}
    void wypisz( void)
    { cout << "[" << this -> x;
      cout << ", " << this -> y;
      cout << ", " << this -> z << "]" << endl; 
    }
    Wektor3d operator -(void) 
    { 
     Wektor3d tmp( -x, -y, -z);
     return tmp;
    }
    Wektor3d operator +( Wektor3d w) 
    { 
     Wektor3d tmp( x + w.x, y + w.y, z + w.z);
     return tmp;
    }
    double operator *( Wektor3d w) 
    { 
     return ( x * w.x + y * w.y + z * w.z);
    }
    bool operator <( const Wektor3d &w) 
    { 
     double r1 = x * x + y * y + z * z;
     double r2 = w.x * w.x + w.y * w.y + w.z * w.z;
     return r1 < r2;
    }
    Wektor3d & operator =( const Wektor3d &w) 
    { 
     if( &w != this)
     {
       cout << "Operator = przy pracy ..." << endl;
       x = w.x;
       y = w.y;
       z = w.z;
     }
     return *this;
    }
};
//------------------------------------------------
int main()
{
 Wektor3d w[ 3], w1( 1, 2, 3);
 cout << "w1 = "; w1.wypisz();
 w[ 0] = w[ 1] = w[ 2] = w1;
 cout << "w[ 0] = "; w[ 0].wypisz();
 cout << "w[ 1] = "; w[ 1].wypisz();
 cout << "w[ 2] = "; w[ 2].wypisz();
 char c;
 cin >> c;
}

