// "C++. wiczenia zaawansowane", Andrzej Stasiewicz, Helion 2004

#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

class LiczbaZespolona
{
  friend ostream & operator << ( ostream &os, const LiczbaZespolona &w);
  private:
    double a, b;
 public:
    LiczbaZespolona( void) : a(0), b(0){}
    LiczbaZespolona( double a, double b) : a(a), b(b){}
    LiczbaZespolona( const LiczbaZespolona &z) : a(z.a), b(z.b){}
    ~LiczbaZespolona(){}
    LiczbaZespolona &operator=( const LiczbaZespolona &z)
    {
     if( &z != this)
     {
       a = z.a; b = z.b;
     }
     return *this;
    }
    bool operator==( const LiczbaZespolona &z)
    {
     cout << "   Operator porownania." << endl;
     return (a == z.a && b == z.b);
    }
    bool operator<( const LiczbaZespolona &z) const
    {
     cout << "   Operator relacji <." << endl;
     double r1 = a * a + b * b, r2 = z.a * z.a + z.b * z.b;
     return (r1 < r2);
    }
};
//------------------------------------------------
ostream & operator << ( ostream &os, const LiczbaZespolona &z) 
{ 
 os << "[" << z.a << ", " << z.b << "]";
 return os;
}
//------------------------------------------------
int main()
{
 cout << "1. Deklaracja pustej tablicy i iteratora." << endl;
 vector<LiczbaZespolona> Az;
 vector<LiczbaZespolona> :: iterator Az_iter;
 cout << "2. Wpisanie kilku elementow." << endl;
 Az.push_back( LiczbaZespolona( 5, 2));
 Az.push_back( LiczbaZespolona( 2, 2));
 Az.push_back( LiczbaZespolona( 3, 2));
 for( Az_iter = Az.begin(); Az_iter != Az.end(); ++Az_iter)
   cout << "   " << *Az_iter << endl;
 cout << "3. Sortowanie kontenera." << endl;
 sort( Az.begin(), Az.end());
 for( Az_iter = Az.begin(); Az_iter != Az.end(); ++Az_iter)
   cout << "   " << *Az_iter << endl;
 char c;
 cin >> c;
}

