#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# streamcipher.sh
#
# Opis:
# Prosta implementacja szyfru strumieniowego
# W celach edukacyjnych - nie zaleca się używania do poważnych celów 
#
# Użycie:           
# streamcipher.sh [-d] <klucz> <plikwejściowy> 
#   -d Tryb rozszyfrowywania
#   <klucz> Klucz numeryczny
#
#

source ./askey.sh                                          # <1>

#
# Ncrypt - Szyfrowanie - wczytuje znaki
#   zwraca 2-cyfrowy znak heksadecymalny #s
#
function Ncrypt ()                                         # <2>
{
    TXT="$1"
    for((i=0; i< ${#TXT}; i++))                            # <3>
    do
	CHAR="${TXT:i:1}"                                  # <4>
	RAW=$(asnum "$CHAR") # " " potrzebny do wstawienia spacji (32)   # <5>
	NUM=${RANDOM}
	COD=$(( RAW ^ ( NUM & 0x7F )))                     # <6>
	printf "%02X" "$COD"                               # <7>
    done
    echo						   # <8>
}

#
# Dcrypt - Rozszyfrowywuje - wczytuje 2-cyfrowy znak heksadecymalny #s 
#   zwraca znaki
#
function Dcrypt ()                                  # <9>
{
    TXT="$1"
    for((i=0; i< ${#TXT}; i=i+2))                   # <10>
    do
	CHAR="0x${TXT:i:2}"                         # <11>
	RAW=$(( $CHAR ))                            # <12>
	NUM=${RANDOM}
	COD=$(( RAW ^ ( NUM & 0x7F )))              # <13>
	aschar "$COD"                               # <14>
    done
    echo
}

if [[ -n $1  &&  $1 == "-d" ]]                      # <15>
then
    DECRYPT="YES" 
    shift                                           # <16>
fi

KEY=${1:-1776}                                      # <17>
RANDOM="${KEY}"                                     # <18>
while read -r                                       # <19>
do
    if [[ -z $DECRYPT ]]	                    # <20>
    then 
	Ncrypt "$REPLY"
    else
	Dcrypt "$REPLY"
    fi

done 
