#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# hashsearch.sh
#
# Opis:
# Rekurencyjnie przeszukuje podany katalog pod kątem pliku, 
# który pasuje do podanej wartości skrótu SHA-1 
#
# Użycie:
# hashsearch.sh <skrót> <katalog>
#   skrót - wartość skrótu SHA-1 dla szukanego pliku 
#   katalog - katalog nadrzędny, od którego należy zacząć wyszukiwanie
#

HASH=$1
DIR=${2:-.}	# wartością domyślną jest wynik polecenia cwd

# przekształcenie ścieżki pliku w ścieżkę bezwzględną
function mkabspath ()				# <6>
{
    if [[ $1 == /* ]]				# <7>
    then
    	ABS=$1
    else
    	ABS="$PWD/$1"				# <8>
    fi
}

find $DIR -type f |				# <1>
while read fn
do
    THISONE=$(sha1sum "$fn")			# <2>
    THISONE=${THISONE%% *}			# <3>
    if [[ $THISONE == $HASH ]]
    then
	mkabspath "$fn"				# <4>
	echo $ABS				# <5>
    fi
done
