#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# softinv.sh
#
# Opis:
# Wyświetla listę programów zainstalowanych w systemie
# potrzebną do dalszej analizy;
#
# Użycie: ./softinv.sh [nazwapliku]
# wynik zostanie zapisany w pliku $1 lub <nazwahosta>_softinv.txt 
#
 							
# ustawianie nazwy pliku wyjściowego
OUTFN="${1:-${HOSTNAME}_softinv.txt}"				# <1>

# uruchamiane polecenie zależy od systemu operacyjnego i od zainstalowanych w nim programów
OSbase=win
type -t rpm &> /dev/null					# <2>
(( $? == 0 )) && OSbase=rpm					# <3>
type -t dpkg &> /dev/null
(( $? == 0 )) && OSbase=deb
type -t apt &> /dev/null
(( $? == 0 )) && OSbase=apt

case ${OSbase} in						# <4>
    win)
	INVCMD="wmic product get name,version //format:csv"
	    ;;
    rpm)
    	INVCMD="rpm -qa"
	    ;;
    deb)
	INVCMD="dpkg -l"
	    ;;
    apt)
    	INVCMD="apt list --installed"
	    ;;
    *)
    	echo "błąd: OSbase=${OSbase}"
	exit -1
	    ;;
esac

#
# uruchamianie inwentaryzacji
#
$INVCMD 2>/dev/null > $OUTFN					# <5>

