#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# fuzzer.sh
#
# Opis:
# Fuzzing określonego argumentu programu
#
# Użycie:
# bash fuzzer.sh <program wykonywalny> <arg1> [?] <arg3> ...                
#   <program wykonywalny> Docelowy program/skrypt wykonywalny
#   <argn> Statyczne argumenty programu wykonywalnego
#   '?' Argument, który będzie modyfikowany                         
#   przykład: fuzzer.sh ./myprog -t '?' fn1 fn2
#

#
function usagexit ()                            # <1>
{
    echo "użycie: $0 plikwykonywalny args" 
    echo "przykład: $0 myapp -lpt arg \?"
    exit 1
} >&2						# <2>

if (($# < 2))					# <3>
then
    usagexit
fi

# aplikacja będzie modyfikować pierwszy argument
THEAPP="$1"
shift						# <4>
# czy został podany?
type -t "$THEAPP" >/dev/null  || usagexit    # <5>

# który argument zmodyfikować?
# znajdź ? i zapisz jego pozycję
declare -i i
for ((i=0; $# ; i++))				# <6>
do
    ALIST+=( "$1" )				# <7>
    if [[ $1 == '?' ]]
    then
	NDX=$i					# <8>
    fi
    shift
done

# printf "Plik wykonywalny: %s  Arg: %d %s\n" "$THEAPP" $NDX "${ALIST[$NDX]}"
                        
# modyfikujemy argumenty:
MAX=10000
FUZONE="a"
FUZARG=""
for ((i=1; i <= MAX; i++))			# <9>
do
    FUZARG="${FUZARG}${FUZONE}"  # aka +=
    ALIST[$NDX]="$FUZARG"
    # kolejność >s ma znaczenie
    $THEAPP "${ALIST[@]}"  2>&1 >/dev/null      # <10>
    if (( $? )) ; then echo "Spowodowany przez: $FUZARG" >&2 ; fi  # <11>
done

