#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# checkpass.sh
#
# Opis:
# Sprawdzanie hasła w bazie danych 
# Have I Been Pwned? 
#
# Użycie: ./checkpass.sh [<hasło>]
#   <hasło> Hasło do sprawdzenia 
#   domyślne: wczytane ze strumienia stdin
#

if (( "$#" == 0 ))                              #<1>
then
    printf 'Wpisz hasło: '
    read -s passin                              #<2>
	echo
else
    passin="$1"    
fi

passin=$(echo -n "$passin" | sha1sum)	          #<3>
passin=${passin:0:40}

firstFive=${passin:0:5}                         #<4>
ending=${passin:5}

pwned=$(curl -s "https://api.pwnedpasswords.com/range/$firstFive" | \
        tr -d '\r' | grep -i "$ending" )        #<5>
passwordFound=${pwned##*:}                      #<6>


if [ "$passwordFound" == "" ]
then
    exit 1
else
    printf 'Hasło wyciekło %d razy!\n' "$passwordFound"
    exit 0
fi

