﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Xml.Serialization;
using System.Xml;
using System.IO;

namespace Xml_Serializacja
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        public struct Wielkość
        {          
            public int Szer;
            public int Wys;
            public Wielkość(int Szer, int Wys)
            {
                this.Szer = Szer;
                this.Wys = Wys;
            }
        }

        public struct Okno
        {
            public Point pozycja;
            public Wielkość wielkość;
            public Okno(Point pozycja, Wielkość wielkość)
            {
                this.pozycja = pozycja;
                this.wielkość = wielkość;
            }
        }

        private string plikUstawien = "Ustawienia.xml";

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            StreamWriter sw=null;
            try
            {
                Okno okno = new Okno(new Point(Left, Top), new Wielkość(Width, Height));
                XmlSerializer xmlsrl = new XmlSerializer(typeof(Okno));
                sw = new StreamWriter(plikUstawien);
                xmlsrl.Serialize(sw, okno);
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd w zapisywaniu ustawień z pliku (" + exc.Message + ")");
            }
            finally
            {
                if (sw!=null) sw.Close();
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            StreamReader sr = null;
            try
            {
                XmlSerializer xmlsrl = new XmlSerializer(typeof(Okno));
                sr = new StreamReader(plikUstawien);
                Okno okno = (Okno)xmlsrl.Deserialize(sr);

                this.Left = okno.pozycja.X;
                this.Top = okno.pozycja.Y;
                this.Width = okno.wielkość.Szer;
                this.Height = okno.wielkość.Wys;
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd w odczytywaniu ustawień z pliku (" + exc.Message + ")");
            }
            finally
            {
                if (sr!=null) sr.Close();
            }            
        }
    }
}
