using System;
using System.Collections.Generic;
using System.Text;

namespace SystemInfo
{
    class Program
    {
        //Informacje o systemie
        static private string systeminfo = "Informacje o systemie:"
            + "\nWersja systemu: " + Environment.OSVersion
            + "\nWersja Microsoft .NET Framework: " + Environment.Version
            + "\nNazwa komputera: " + Environment.MachineName
            + "\nKatalog systemowy: " + Environment.SystemDirectory
            + "\n\n";

        //Informacje o biecym uytkowniku
        static private string userinfo = "Informacje o biecym uytkowniku:"
        + "\nNazwa uytkownika: " + Environment.UserName
        + "\nKatalogi specjalne uytkownika:"
        + "\n\tKatalog domowy uytkownika: " + Environment.GetEnvironmentVariable("USERPROFILE")
        + "\n\tkatalog 'Moje dokumenty' = " + Environment.GetFolderPath(Environment.SpecialFolder.Personal)
        + "\n\tkatalog 'Pulpit' = " + Environment.GetFolderPath(Environment.SpecialFolder.Desktop)
        + "\n\tkatalog 'Moj komputer' = " + Environment.GetFolderPath(Environment.SpecialFolder.MyComputer)
        + "\n\tkatalog 'Moje obrazy' = " + Environment.GetFolderPath(Environment.SpecialFolder.MyPictures)
        + "\n\tkatalog menu Start = " + Environment.GetFolderPath(Environment.SpecialFolder.StartMenu)
        + "\n\tkatalog 'Programy' = " + Environment.GetFolderPath(Environment.SpecialFolder.Programs)
        + "\n\tkatalog 'Autostart' = " + Environment.GetFolderPath(Environment.SpecialFolder.Startup);

        static void Main(string[] args)
        {
            Console.WriteLine("SystemInfo\n----------\n");
            Console.WriteLine(systeminfo + "\n");
            Console.WriteLine(userinfo + "\n");

            //Zmienne rodowiskowe
            string zmienne = "";
            System.Collections.IDictionary zmienneSrodowiskowe = Environment.GetEnvironmentVariables();
            foreach (System.Collections.DictionaryEntry zmienna in zmienneSrodowiskowe)
                zmienne += "\t" + zmienna.Key + " = " + zmienna.Value + "\n";
            Console.WriteLine("\nZmienne rodowiskowe:\n" + zmienne);

            //Dyski
            string[] dyski = Environment.GetLogicalDrives();
            string driveinfo = "\nDyski: ";
            foreach (string dysk in dyski) driveinfo += dysk + " ";
            Console.WriteLine(driveinfo + "\n");
        }
    }
}
