;; ----------------------------------------------------------- ;;
;;  OKRAG09.LSP                                                ;;
;;  AutoCAD. LSP i DCL. Cwiczenia praktyczne 		       ;;
;;                                                             ;;
;;  Copyright (c) Dariusz Frenki        dar@cad.pl             ;;  
;;                                      www.dar.cad.pl         ;;
;; ----------------------------------------------------------- ;;

;; Program zawierajacy wywolanie okna okna dialogowego,
;; inicjalizacje wycinkow zamykajacych OK i CANCEL EDIT_BOX, TOGGLE
;; Definiuje liste w wycinku typu POPUP_BOX i wycinki piktogramowe
;; typu IMAGE
;; Dodatkowo rysuje okrag i opcjonalnie osie symetrii tego okregu
;; Kod definiuje take program IKONKA, ktry wypelnia wycinki 
;; piktograwe odpowiednim kolorem oraz program BLOKOWANIE, ktry
;; blokuje odpowiednie wycinki przed edycja
;; Pragram WSTAW_LISTE powoduje wyswietlenie list w odpowiednich
;; polach okna dialogowego

(defun c:okrag09 ( / )

  (setq dcl_id(load_dialog "okrag09"))
  (if(not(new_dialog "okrag09" dcl_id))
    (progn
      (alert "Nie znaleziono pliku OKRAG09.DCL")
      (exit)
    );progn
  );if

  (action_tile "promien" "(setq promien (atof $value))")

  (setq osie 0)
  (blokowanie)

  (action_tile "osie" "(setq osie (atoi $value)) (blokowanie)")

  (setq kolory (list "czerwony" "ty" "zielony" "bkitny" "niebieski" "fioletowy" "biay"))

  (wstaw_liste "kolor_okrag" kolory)
  (wstaw_liste "kolor_osie" kolory)

  (setq kolor_okrag 0)
  (ikonka "kolor_image_okrag" kolor_okrag)

  (setq kolor_osie 0)
  (ikonka "kolor_image_osie" kolor_osie)

  (action_tile "kolor_okrag" "(setq kolor_okrag (atoi $value))
                              (ikonka \"kolor_image_okrag\" kolor_okrag)")

  (action_tile "kolor_osie" "(setq kolor_osie (atoi $value))
                              (ikonka \"kolor_image_osie\" kolor_osie)")


  (action_tile "accept" "(done_dialog) (setq zamkniecie 1)")
  (action_tile "cancel" "(done_dialog) (setq zamkniecie 0)")

  (start_dialog)
  (unload_dialog dcl_id)


  (if (= zamkniecie 1)
    (progn

      (command "_color" (1+ kolor_okrag) "")      

      (setq srodek (getpoint "\nWska punkt rodka okrgu: "))
      (command "_circle" srodek promien "")

      (if (= osie 1)
        (progn
          (command "_color" (1+ kolor_osie) "")
          (setq a (+ promien 3))
          (setq kat_90 (/ pi 2))
          (setq kat_270 (* 3 kat_90))
          (setq p1 (polar srodek kat_90 a))
          (setq p2 (polar srodek kat_270 a))
          (setq p3 (polar srodek 0 a))
          (setq p4 (polar srodek pi a))
          (command "_line" p1 p2 "")
          (command "_line" p3 p4 "")
        );progn
      );if

    );progn
  );if

  (command "_color" "_bylayer" "")      

  (princ)
);defun

(defun ikonka ( nazwa_klucza kolor_tla / )
  (start_image nazwa_klucza)
  (setq dx (dimx_tile nazwa_klucza))
  (setq dy (dimy_tile nazwa_klucza))
  (fill_image 0 0 dx dy (1+ kolor_tla))
  (end_image)
);defun



(defun wstaw_liste ( nazwa_klucza nazwa_listy / )
  (start_list nazwa_klucza)
  (mapcar 'add_list nazwa_listy)
  (end_list)
  (set_tile nazwa_klucza "0")
);defun


(defun blokowanie ( / )
  (if (= osie 1)
    (progn
      (mode_tile "kolor_osie" 0)
      (mode_tile "kolor_image_osie" 0)
    );progn

    (progn
      (mode_tile "kolor_osie" 1)
      (mode_tile "kolor_image_osie" 1)
    );progn
  );if
);defun

(princ)
