;; ----------------------------------------------------------- ;;
;;  OKRAG08.LSP                                                ;;
;;  AutoCAD. LSP i DCL. Cwiczenia praktyczne 		       ;;
;;                                                             ;;
;;  Copyright (c) Dariusz Frenki        dar@cad.pl             ;;  
;;                                      www.dar.cad.pl         ;;
;; ----------------------------------------------------------- ;;

;; Program zawierajacy wywolanie okna okna dialogowego,
;; inicjalizacje wycinkow zamykajacych OK i CANCEL EDIT_BOX, TOGGLE
;; Dodatkowo rysuje okrag i opcjonalnie osie symetrii tego okregu
;; Kod definiuje przypisanie odpowiedniego koloru po wybraniu 
;; przez uzytkownika kolorowego pola (piktogramu)

(defun c:okrag08 ( / )

  (setq dcl_id(load_dialog "okrag08"))
  (if(not(new_dialog "okrag08" dcl_id))
    (progn
      (alert "Nie znaleziono pliku OKRAG08.DCL") 
      (exit)
    );progn
  );if

  (action_tile "promien" "(setq promien (atof $value))")

  (setq osie 0)
  (action_tile "osie" "(setq osie (atoi $value))")

  (setq kolor "bylayer")

  (action_tile "001" "(setq kolor 1)")
  (action_tile "002" "(setq kolor 2)")
  (action_tile "003" "(setq kolor 3)")
  (action_tile "004" "(setq kolor 4)")
  (action_tile "005" "(setq kolor 5)")
  (action_tile "006" "(setq kolor 6)")
  (action_tile "007" "(setq kolor 7)")

  (action_tile "accept" "(done_dialog) (setq zamkniecie 1)")
  (action_tile "cancel" "(done_dialog) (setq zamkniecie 0)")

  (start_dialog)
  (unload_dialog dcl_id)


  (if (= zamkniecie 1)
    (progn

      (command "_color" kolor "")      

      (setq srodek (getpoint "\nWska punkt rodka okrgu: "))
      (command "_circle" srodek promien "")

      (if (= osie 1)
        (progn
          (setq a (+ promien 3))
          (setq kat_90 (/ pi 2))
          (setq kat_270 (* 3 kat_90))
          (setq p1 (polar srodek kat_90 a))
          (setq p2 (polar srodek kat_270 a))
          (setq p3 (polar srodek 0 a))
          (setq p4 (polar srodek pi a))
          (command "_line" p1 p2 "")
          (command "_line" p3 p4 "")
        );progn
      );if

    );progn
  );if

  (command "_color" "_bylayer" "")      

  (princ)
);defun

(princ)
