;; ----------------------------------------------------------- ;;
;;  OKRAG05.LSP                                                ;;
;;  AutoCAD. LSP i DCL. Cwiczenia praktyczne 		       ;;
;;                                                             ;;
;;  Copyright (c) Dariusz Frenki        dar@cad.pl             ;;  
;;                                      www.dar.cad.pl         ;;
;; ----------------------------------------------------------- ;;

;; Program zawierajacy wywolanie okna okna dialogowego,
;; inicjalizacje wycinkow zamykajacych OK i CANCEL EDIT_BOX, TOGGLE
;; Definiuje liste w wycinku typu LIST_BOX
;; Dodatkowo rysuje okrag i opcjonalnie osie symetrii tego okregu

(defun c:okrag05 ( / )

  (setq dcl_id(load_dialog "okrag05"))
  (if(not(new_dialog "okrag05" dcl_id))
    (progn
      (alert "Nie znaleziono pliku OKRAG05.DCL")
      (exit)
    );progn
  );if

  (action_tile "promien" "(setq promien (atof $value))")

  (setq osie 0)
  (action_tile "osie" "(setq osie (atoi $value))")

  (setq kolory (list "czerwony" "ty" "zielony" "bkitny" "niebieski" "fioletowy" "biay"))

  (start_list "kolor")
  (mapcar 'add_list kolory)
  (end_list)
  (set_tile "kolor" "0")

  (setq kolor 0)
  (action_tile "kolor" "(setq kolor (atoi $value))")


  (action_tile "accept" "(done_dialog) (setq zamkniecie 1)")
  (action_tile "cancel" "(done_dialog) (setq zamkniecie 0)")

  (start_dialog)
  (unload_dialog dcl_id)


  (if (= zamkniecie 1)
    (progn

      (command "_color" (1+ kolor) "")      

      (setq srodek (getpoint "\nWska punkt rodka okrgu: "))
      (command "_circle" srodek promien "")

      (if (= osie 1)
        (progn
          (setq a (+ promien 3))
          (setq kat_90 (/ pi 2))
          (setq kat_270 (* 3 kat_90))
          (setq p1 (polar srodek kat_90 a))
          (setq p2 (polar srodek kat_270 a))
          (setq p3 (polar srodek 0 a))
          (setq p4 (polar srodek pi a))
          (command "_line" p1 p2 "")
          (command "_line" p3 p4 "")
        );progn
      );if

    );progn
  );if

  (command "_color" "_bylayer" "")      

  (princ zamkniecie)
  (princ osie)

  (princ)
);defun
(princ)
